/* 
 *  ACWRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;

public class ACWRequest extends UserRequest {

    private static final Logger LOG = Logger.getLogger(ACWRequest.class);
    private final String reason;

    public ACWRequest(String userID, String reason) {
        super(LOG, userID);
        this.reason = reason;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getUser().afterCallWork(this.reason);
        LOG.trace(methodName + "-");
        return null;
    }
}
